buddahbrots(ATTRACTOR)
{
/* Originally discovered by Melinda Green */
/* Rewritten by F. Bernkastel for Attractor (plasma) render method*/
/* Update 2015-09: generally optimized & reduced memory usage */

/* F.Bernkastel 2015, webmaster@animewka.cc.kg */

  shared double colorIndex;
  parameter int _maxiter,_miniter;
  parameter complex perturb;
  parameter complex juliaSeed;
  parameter complex power;
  parameter int powerType;
  parameter int itype, pplane, ptype;
  parameter real _bailout;
  parameter complex windowSize, windowCenter;
  parameter bool internalcolor;
  parameter int internalcolortype;
  parameter bool juliaMode;
  complex z_,_pixel,location;
  real u,v;
  int i, _maxiter_r;
  bool plotit,outside;
  
  void init(void)
  {
  }
    
  void loop(void)
  {
    u = random.real()*real(windowSize)-real(windowSize)/2 + real(windowCenter);
    v = random.real()*imag(windowSize)-imag(windowSize)/2 + imag(windowCenter);
    if (juliaMode)
    {
    	_pixel = juliaSeed;
    	z_ = complex(u,v);
    }
    else
    {	
    	z_ = perturb;
    	_pixel = complex(u,v);
    }
    i = 0;
	location=(0,0);
    _maxiter_r = trunc(random.real()*_maxiter)+1;
    while((|z_| < _bailout) && (i < _maxiter))
    { 
      if (powerType == 0)
      {
        z_ = sqr(z_) + pixfn(_pixel);
      }
      else
      {
        z_ = z_^power + pixfn(_pixel);
      }
	  if (i == _maxiter_r)
	  {
		location = z_;
	  }
      i = i + 1;
    } 
    if ((itype == 0) || (pplane == 0)) //Z.r Z.i
    {

    }
    else if (pplane == 1)             //Z.r C.r
    {
      location = complex(real(location), real(_pixel));
    }
    else if (pplane == 2)             //Z.r C.i
    {
      location = complex(real(location), imag(_pixel));
    }
    else if (pplane == 3)             //Z.i C.r
    {
      location = complex(imag(location), real(_pixel));
    }
    else if (pplane == 4)             //Z.i C.i
    {
      location = complex(imag(location), imag(_pixel));
    }
    else if (pplane == 5)             //C.r C.i
    {
      location = _pixel;
    }
    outside = (i < _maxiter);
    if ((ptype == 0) && outside) //Outside (Buddahbrot)
    {
      plotit = true;
    }
    else if ((ptype ==1) && !outside) //Inside (Anti - buddahbrot)
    {
      plotit = true;
    }
    else if (ptype == 2) //both
    {
      plotit = true;
    }
    else 
    {
      plotit = false;
    }
    if (plotit)
    {
      colorIndex = i;
      if(|location|>0){
        z = vector(real(location), imag(location), 0);
      }
      if (internalcolor)
      {
        if ((internalcolortype == 0) && ((ptype == 0) || (ptype == 2)))
        {
          colorIndex = i / _maxiter * 255;
        }
        else if ((internalcolortype == 0) && (ptype == 1))
        {
          colorIndex = i / colorIndex * 255;
        }
        else if (internalcolortype == 1)
        {
          colorIndex = |z_|;
        }
        else if (internalcolortype == 2)
        {
          colorIndex = |_pixel|;
        }
      }
    }
  }
    
  void description(void)
  {
    separator.label1.caption = "Mandelbrot parameters";
    
    juliaMode.caption = "Julia Mode";
    juliaMode.default = false;
    
    _maxiter.caption = "Maximum iterations";
    _maxiter.default = 50;
    
    _miniter.caption = "Minimum iterations";
    _miniter.default = 0;
    
    perturb.caption = "Perturbation";
    perturb.hint = "Start value for the iteration, also called perturbation";
    perturb.default = (0,0);
    perturb.visible = !juliaMode;
    
    juliaSeed.caption = "Julia Seed";
    juliaSeed.default = (0.34, 0.39);
    juliaSeed.visible = juliaMode;
    
    _bailout.caption = "Bailout";
    _bailout.default = 4;
    
    powerType.caption = "Power Type";
    powerType.enum = "Z^2\nArbitraty power";
    powerType.default = 0;
    
    power.caption = "power";
    power.default = (3,0);
    power.visible = powerType == 1;
    
    pixfn.caption = "Pixel Addition";
    pixfn.default = "ident";
    
    separator.label2.caption = "Source square";
    
    windowSize.caption = "Range";
    windowSize.default = (3,2.5);
    
    windowCenter.caption = "Center";
    windowCenter.default = (0,0);
    
    separator.label3.caption = "Advanced";
    
    itype.caption = "Image Type";
    itype.default =  0;
    itype.enum = "Classic\nHologram";
    
    pplane.caption = "Projection Plane";
    pplane.default =  0;
    pplane.enum = "Z.r,Z.i\nZ.r,C.r\nZ.r,C.i\nZ.i,C.r\nZ.i,C.i\nC.r,C.i";
    pplane.visible =  itype==1;
    pplane.enabled =  itype==1;    
    
    ptype.caption = "Plot Type";
    ptype.default =  1;
    ptype.enum = "Outside(Buddhabrot)\nInside(Anti-Buddahbrot)\nBoth";		
    
    separator.label4.caption = "Coloring";
    
    internalcolor.caption = "Enable internal coloring";
    internalcolor.default = true;
    internalcolor.hint="If checked, the formula uses the internal coloring, which only works if you select coloring formula 'Attractor Internal Coloring'";
    internalcolortype.caption = "Color index = ";
    internalcolortype.default = 2;
    internalcolortype.enum = "iter/maxiter\n|Z|\n|c|";
    internalcolortype.visible = internalcolor;
  }
}

